/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.player;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.sound.PortalTriggerSoundInstance;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import com.aetherteam.aether.entity.miscellaneous.Parachute;
import com.aetherteam.aether.entity.passive.Aerbunny;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.miscellaneous.ParachuteItem;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.clientbound.CloudMinionPacket;
import com.aetherteam.aether.network.packet.clientbound.RemountAerbunnyPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.data.ClientDeveloperGlowPerkData;
import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_465;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class AetherPlayerCapability
implements AetherPlayer {
    private final class_1657 player;
    private static final UUID LIFE_SHARD_HEALTH_ID = UUID.fromString("E11710C8-4247-4CB6-B3B5-729CB34CFC1A");
    private boolean canGetPortal = true;
    private boolean canSpawnInAether = true;
    public boolean isInAetherPortal = false;
    public int aetherPortalTimer = 0;
    public float prevPortalAnimTime;
    public float portalAnimTime = 0.0f;
    private boolean isHitting;
    private boolean isMoving;
    private boolean isJumping;
    private boolean isGravititeJumpActive;
    private boolean seenSunSpiritDialogue;
    private int goldenDartCount;
    private int poisonDartCount;
    private int enchantedDartCount;
    private int removeGoldenDartTime;
    private int removePoisonDartTime;
    private int removeEnchantedDartTime;
    private int remedyStartDuration;
    private int impactedMaximum;
    private int impactedTimer;
    private boolean performVampireHealing;
    @Nullable
    private Aerbunny mountedAerbunny;
    @Nullable
    private class_2487 mountedAerbunnyTag;
    @Nullable
    private UUID lastRiddenMoa;
    private final List<CloudMinion> cloudMinions = new ArrayList<CloudMinion>(2);
    private int wingRotationO;
    private int wingRotation;
    private int invisibilityAttackCooldown;
    private boolean attackedWithInvisibility;
    private boolean invisibilityEnabled = true;
    private boolean wearingInvisibilityCloak;
    private static final int FLIGHT_TIMER_MAX = 52;
    private static final float FLIGHT_MODIFIER_MAX = 15.0f;
    private int flightTimer;
    private float flightModifier = 1.0f;
    private double neptuneSubmergeLength;
    private double phoenixSubmergeLength;
    private static final int OBSIDIAN_TIMER_MAX = 20;
    private int obsidianConversionTime;
    private float savedHealth = 0.0f;
    private int lifeShards;
    private static final class_2960 LOGOMARKS = new class_2960("aether", "logomarks");
    private static final class_2583 DISCORD = class_2583.field_24360.method_36139(5793266).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://discord.gg/aethermod")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"https://discord.gg/aethermod")));
    private static final class_2583 PATREON = class_2583.field_24360.method_36139(16728653).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.patreon.com/TheAetherTeam")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"https://www.patreon.com/TheAetherTeam")));
    private boolean canShowPatreonMessage = true;
    private int loginsUntilPatreonMessage = -1;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setHitting", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setHitting((Boolean)object), this::isHitting)), Map.entry("setMoving", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setMoving((Boolean)object), this::isMoving)), Map.entry("setJumping", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setJumping((Boolean)object), this::isJumping)), Map.entry("setGravititeJumpActive", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setGravititeJumpActive((Boolean)object), this::isGravititeJumpActive)), Map.entry("setGoldenDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setGoldenDartCount((Integer)object), this::getGoldenDartCount)), Map.entry("setPoisonDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setPoisonDartCount((Integer)object), this::getPoisonDartCount)), Map.entry("setEnchantedDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setEnchantedDartCount((Integer)object), this::getEnchantedDartCount)), Map.entry("setRemedyStartDuration", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setRemedyStartDuration((Integer)object), this::getRemedyStartDuration)), Map.entry("setAttackedWithInvisibility", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setAttackedWithInvisibility((Boolean)object), this::attackedWithInvisibility)), Map.entry("setInvisibilityEnabled", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setInvisibilityEnabled((Boolean)object), this::isInvisibilityEnabled)), Map.entry("setWearingInvisibilityCloak", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setWearingInvisibilityCloak((Boolean)object), this::isWearingInvisibilityCloak)), Map.entry("setLifeShardCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setLifeShardCount((Integer)object), this::getLifeShardCount)), Map.entry("setLastRiddenMoa", Triple.of((Object)INBTSynchable.Type.UUID, object -> this.setLastRiddenMoa((UUID)object), this::getLastRiddenMoa)), Map.entry("setShouldSyncBetweenClients", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldSyncBetweenClients((Boolean)object), this::shouldSyncBetweenClients)));
    private boolean shouldSyncAfterJoin;
    private boolean shouldSyncBetweenClients;

    public AetherPlayerCapability(class_1657 player) {
        this.player = player;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10556("CanGetPortal", this.canGetPortal());
        tag.method_10556("CanSpawnInAether", this.canSpawnInAether());
        tag.method_10548("SavedHealth", this.getSavedHealth());
        tag.method_10569("LifeShardCount", this.getLifeShardCount());
        tag.method_10556("HasSeenSunSpirit", this.hasSeenSunSpiritDialogue());
        tag.method_10569("RemedyStartDuration", this.getRemedyStartDuration());
        if (this.getMountedAerbunnyTag() != null) {
            tag.method_10566("MountedAerbunnyTag", (class_2520)this.getMountedAerbunnyTag());
        }
        if (this.getLastRiddenMoa() != null) {
            tag.method_25927("LastRiddenMoa", this.getLastRiddenMoa());
        }
        tag.method_10556("CanShowPatreonMessage", this.canShowPatreonMessage);
        tag.method_10569("LoginsUntilPatreonMessage", this.loginsUntilPatreonMessage);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545("CanGetPortal")) {
            this.setCanGetPortal(tag.method_10577("CanGetPortal"));
        }
        if (tag.method_10545("CanSpawnInAether")) {
            this.setCanSpawnInAether(tag.method_10577("CanSpawnInAether"));
        }
        if (tag.method_10545("SavedHealth")) {
            this.setSavedHealth(tag.method_10583("SavedHealth"));
        }
        if (tag.method_10545("LifeShardCount")) {
            this.setLifeShardCount(tag.method_10550("LifeShardCount"));
        }
        if (tag.method_10545("HasSeenSunSpirit")) {
            this.setSeenSunSpiritDialogue(tag.method_10577("HasSeenSunSpirit"));
        }
        if (tag.method_10545("RemedyStartDuration")) {
            this.setRemedyStartDuration(tag.method_10550("RemedyStartDuration"));
        }
        if (tag.method_10545("MountedAerbunnyTag")) {
            this.setMountedAerbunnyTag(tag.method_10562("MountedAerbunnyTag"));
        }
        if (tag.method_10545("LastRiddenMoa")) {
            this.setLastRiddenMoa(tag.method_25926("LastRiddenMoa"));
        }
        if (tag.method_10545("CanShowPatreonMessage")) {
            this.canShowPatreonMessage = tag.method_10577("CanShowPatreonMessage");
        }
        if (tag.method_10545("LoginsUntilPatreonMessage")) {
            this.loginsUntilPatreonMessage = tag.method_10550("LoginsUntilPatreonMessage");
        }
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public void onLogout() {
        this.removeAerbunny();
        this.handleLogoutSavedHealth();
    }

    @Override
    public void onLogin() {
        this.handleGivePortal();
        this.remountAerbunny();
        this.handlePatreonMessage();
        this.shouldSyncAfterJoin = true;
        ServerPerkData.MOA_SKIN_INSTANCE.syncFromServer(this.getPlayer());
        ServerPerkData.HALO_INSTANCE.syncFromServer(this.getPlayer());
        ServerPerkData.DEVELOPER_GLOW_INSTANCE.syncFromServer(this.getPlayer());
    }

    @Override
    public void onJoinLevel() {
        if (this.getPlayer().method_37908().method_8608()) {
            CustomizationsOptions.INSTANCE.load();
            this.setSynched(INBTSynchable.Direction.SERVER, "setShouldSyncBetweenClients", true);
        }
    }

    @Override
    public void copyFrom(AetherPlayer other, boolean isWasDeath) {
        if (!isWasDeath) {
            this.setRemedyStartDuration(other.getRemedyStartDuration());
            this.setProjectileImpactedMaximum(other.getProjectileImpactedMaximum());
            this.setProjectileImpactedTimer(other.getProjectileImpactedTimer());
        }
        this.setCanGetPortal(other.canGetPortal());
        this.setLifeShardCount(other.getLifeShardCount());
        this.handleCopyingSavedHealth(other, isWasDeath);
        this.shouldSyncAfterJoin = true;
    }

    @Override
    public void onUpdate() {
        this.syncAfterJoin();
        this.syncClients();
        this.handleAetherPortal();
        this.activateParachute();
        this.handleRemoveDarts();
        this.removeRemedyDuration();
        this.tickDownProjectileImpact();
        this.handleWingRotation();
        this.handleAttackCooldown();
        this.handleVampireHealing();
        this.checkToRemoveAerbunny();
        this.checkToRemoveCloudMinions();
        this.handleSavedHealth();
        this.handleLifeShardModifier();
        ClientMoaSkinPerkData.INSTANCE.syncFromClient(this.getPlayer());
        ClientHaloPerkData.INSTANCE.syncFromClient(this.getPlayer());
        ClientDeveloperGlowPerkData.INSTANCE.syncFromClient(this.getPlayer());
    }

    private void syncAfterJoin() {
        if (this.shouldSyncAfterJoin) {
            this.forceSync(INBTSynchable.Direction.CLIENT);
            this.shouldSyncAfterJoin = false;
        }
    }

    private void syncClients() {
        if (this.shouldSyncBetweenClients()) {
            MinecraftServer server;
            if (!this.getPlayer().method_37908().method_8608() && (server = this.getPlayer().method_37908().method_8503()) != null) {
                class_3324 playerList = server.method_3760();
                for (class_3222 serverPlayer : playerList.method_14571()) {
                    AetherPlayer aetherPlayer;
                    if (serverPlayer.method_5667().equals(this.getPlayer().method_5667()) || !((aetherPlayer = AetherPlayer.get((class_1657)serverPlayer)) instanceof AetherPlayerCapability)) continue;
                    AetherPlayerCapability capability = (AetherPlayerCapability)aetherPlayer;
                    capability.forceSync(INBTSynchable.Direction.CLIENT);
                }
            }
            this.setShouldSyncBetweenClients(false);
        }
    }

    @Override
    public void setCanSpawnInAether(boolean canSpawnInAether) {
        this.canSpawnInAether = canSpawnInAether;
    }

    @Override
    public boolean canSpawnInAether() {
        return this.canSpawnInAether;
    }

    private void handleGivePortal() {
        if (((Boolean)AetherConfig.COMMON.start_with_portal.get()).booleanValue()) {
            this.givePortalItem();
        } else {
            this.setCanGetPortal(false);
        }
    }

    private void handleAetherPortal() {
        if (this.getPlayer().method_37908().method_8608()) {
            this.prevPortalAnimTime = this.portalAnimTime;
            class_310 minecraft = class_310.method_1551();
            if (this.isInAetherPortal) {
                if (minecraft.field_1755 != null && !minecraft.field_1755.method_25421()) {
                    if (minecraft.field_1755 instanceof class_465) {
                        this.getPlayer().method_7346();
                    }
                    minecraft.method_1507(null);
                }
                if (this.getPortalAnimTime() == 0.0f) {
                    this.playPortalSound(minecraft);
                }
            }
        }
        if (this.isInPortal()) {
            ++this.aetherPortalTimer;
            if (this.getPlayer().method_37908().method_8608()) {
                this.portalAnimTime += 0.0125f;
                if (this.getPortalAnimTime() > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInAetherPortal = false;
        } else {
            if (this.getPlayer().method_37908().method_8608()) {
                if (this.getPortalAnimTime() > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.getPortalAnimTime() < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.getPortalTimer() > 0) {
                this.aetherPortalTimer -= 4;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void playPortalSound(class_310 minecraft) {
        minecraft.method_1483().method_4873((class_1113)PortalTriggerSoundInstance.forLocalAmbience(this.player, (class_3414)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRIGGER.get(), this.player.method_6051().method_43057() * 0.4f + 0.8f, 0.25f));
    }

    private void activateParachute() {
        class_1657 player = this.getPlayer();
        class_1661 inventory = this.getPlayer().method_31548();
        class_1937 level = player.method_37908();
        if (!player.method_7337() && !player.method_5715() && !player.method_6128() && !player.method_5765() && player.method_18798().method_10214() < -1.5 && inventory.method_7382(AetherTags.Items.DEPLOYABLE_PARACHUTES)) {
            for (class_1799 stack : inventory.field_7547) {
                ParachuteItem parachuteItem;
                Parachute parachute;
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof ParachuteItem) || (parachute = (Parachute)(parachuteItem = (ParachuteItem)class_17922).getParachuteEntity().get().method_5883(level)) == null) continue;
                parachute.method_5814(player.method_23317(), player.method_23318() - 1.0, player.method_23321());
                parachute.method_18799(player.method_18798());
                if (!level.method_8608()) {
                    level.method_8649((class_1297)parachute);
                    player.method_5804((class_1297)parachute);
                    stack.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
                }
                parachute.spawnExplosionParticle();
                break;
            }
        }
    }

    private void handleRemoveDarts() {
        if (!this.getPlayer().method_37908().method_8608()) {
            if (this.getGoldenDartCount() > 0) {
                if (this.removeGoldenDartTime <= 0) {
                    this.removeGoldenDartTime = 20 * (30 - this.getGoldenDartCount());
                }
                --this.removeGoldenDartTime;
                if (this.removeGoldenDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setGoldenDartCount", this.getGoldenDartCount() - 1);
                }
            }
            if (this.getPoisonDartCount() > 0) {
                if (this.removePoisonDartTime <= 0) {
                    this.removePoisonDartTime = 20 * (30 - this.getPoisonDartCount());
                }
                --this.removePoisonDartTime;
                if (this.removePoisonDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setPoisonDartCount", this.getPoisonDartCount() - 1);
                }
            }
            if (this.getEnchantedDartCount() > 0) {
                if (this.removeEnchantedDartTime <= 0) {
                    this.removeEnchantedDartTime = 20 * (30 - this.getEnchantedDartCount());
                }
                --this.removeEnchantedDartTime;
                if (this.removeEnchantedDartTime <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setEnchantedDartCount", this.getEnchantedDartCount() - 1);
                }
            }
        }
    }

    private void removeRemedyDuration() {
        if (this.remedyStartDuration > 0 && !this.getPlayer().method_6059((class_1291)AetherEffects.REMEDY.get())) {
            this.remedyStartDuration = 0;
        }
    }

    private void tickDownProjectileImpact() {
        if (this.getPlayer().method_37908().method_8608()) {
            if (this.getProjectileImpactedTimer() > 0) {
                this.setProjectileImpactedTimer(this.getProjectileImpactedTimer() - 1);
            } else {
                this.setProjectileImpactedMaximum(0);
                this.setProjectileImpactedTimer(0);
            }
        }
    }

    private void handleWingRotation() {
        if (this.getPlayer().method_37908().method_8608()) {
            this.wingRotationO = this.getWingRotation();
            this.wingRotation = EquipmentUtil.hasFullValkyrieSet((class_1309)this.getPlayer()) ? this.getPlayer().field_6012 : 0;
        }
    }

    private void handleAttackCooldown() {
        if (!this.getPlayer().method_37908().method_8608()) {
            if (this.attackedWithInvisibility()) {
                --this.invisibilityAttackCooldown;
                if (this.invisibilityAttackCooldown <= 0) {
                    this.setSynched(INBTSynchable.Direction.CLIENT, "setAttackedWithInvisibility", false);
                }
            } else {
                this.invisibilityAttackCooldown = (Integer)AetherConfig.SERVER.invisibility_visibility_time.get();
            }
        }
    }

    private void handleVampireHealing() {
        if (!this.getPlayer().method_37908().method_8608() && this.performVampireHealing()) {
            this.getPlayer().method_6025(1.0f);
            this.setVampireHealing(false);
        }
    }

    private void checkToRemoveAerbunny() {
        if (!(this.getMountedAerbunny() == null || this.getMountedAerbunny().method_5805() && this.getPlayer().method_5805())) {
            this.setMountedAerbunny(null);
        }
    }

    private void removeAerbunny() {
        if (this.getMountedAerbunny() != null) {
            Aerbunny aerbunny = this.getMountedAerbunny();
            class_2487 nbt = new class_2487();
            aerbunny.method_5662(nbt);
            this.setMountedAerbunnyTag(nbt);
            aerbunny.method_5848();
            aerbunny.method_31745(class_1297.class_5529.field_27001);
        }
    }

    private void remountAerbunny() {
        if (this.getMountedAerbunnyTag() != null) {
            if (!this.getPlayer().method_37908().method_8608()) {
                Aerbunny aerbunny = new Aerbunny((class_1299<? extends Aerbunny>)((class_1299)AetherEntityTypes.AERBUNNY.get()), this.getPlayer().method_37908());
                aerbunny.method_5651(this.getMountedAerbunnyTag());
                this.getPlayer().method_37908().method_8649((class_1297)aerbunny);
                aerbunny.method_5804((class_1297)this.getPlayer());
                this.setMountedAerbunny(aerbunny);
                class_1657 class_16572 = this.getPlayer();
                if (class_16572 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16572;
                    PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new RemountAerbunnyPacket(this.getPlayer().method_5628(), aerbunny.method_5628()), (class_3222)serverPlayer);
                }
            }
            this.setMountedAerbunnyTag(null);
        }
    }

    private void checkToRemoveCloudMinions() {
        this.getCloudMinions().removeIf(cloudMinion -> !cloudMinion.method_5805());
    }

    private void handleSavedHealth() {
        class_1324 health;
        if (this.getSavedHealth() > 0.0f && (health = this.getPlayer().method_5996(class_5134.field_23716)) != null && health.method_6196(this.getLifeShardHealthAttributeModifier())) {
            if (this.getSavedHealth() >= this.getPlayer().method_6063()) {
                this.getPlayer().method_6033(this.getPlayer().method_6063());
            } else {
                this.getPlayer().method_6033(this.getSavedHealth());
            }
            this.setSavedHealth(0.0f);
        }
    }

    private void handleLifeShardModifier() {
        if (!this.getPlayer().method_37908().method_8608()) {
            class_1324 health = this.getPlayer().method_5996(class_5134.field_23716);
            class_1322 lifeShardHealth = this.getLifeShardHealthAttributeModifier();
            if (health != null) {
                if (health.method_6196(lifeShardHealth)) {
                    health.method_6202(lifeShardHealth);
                }
                health.method_26835(lifeShardHealth);
            }
        }
    }

    private void handleLogoutSavedHealth() {
        class_1324 health = this.getPlayer().method_5996(class_5134.field_23716);
        if (health != null && health.method_6196(this.getLifeShardHealthAttributeModifier())) {
            this.setSavedHealth(this.getPlayer().method_6032());
        }
    }

    private void handleCopyingSavedHealth(AetherPlayer other, boolean isWasDeath) {
        if (!isWasDeath) {
            this.setSavedHealth(other.getPlayer().method_6032());
        } else if (this.getPlayer().method_6032() == this.getPlayer().method_6063()) {
            this.setSavedHealth(1024.0f);
        }
    }

    private void handlePatreonMessage() {
        class_1657 class_16572 = this.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue() && this.canShowPatreonMessage) {
                if (this.loginsUntilPatreonMessage < 0 && serverPlayer.method_37908().method_27983() == AetherDimensions.AETHER_LEVEL && (serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956((Object)((class_1299)AetherEntityTypes.SLIDER.get()))) > 0 || serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956((Object)((class_1299)AetherEntityTypes.VALKYRIE_QUEEN.get()))) > 0 || serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956((Object)((class_1299)AetherEntityTypes.SUN_SPIRIT.get()))) > 0)) {
                    this.loginsUntilPatreonMessage = serverPlayer.method_6051().method_43048(2);
                }
                if (this.loginsUntilPatreonMessage == 0) {
                    this.sendPatreonMessage(serverPlayer);
                    this.canShowPatreonMessage = false;
                    AetherConfig.COMMON.show_patreon_message.set((Object)false);
                    AetherConfig.COMMON.show_patreon_message.save();
                } else if (this.loginsUntilPatreonMessage > 0) {
                    --this.loginsUntilPatreonMessage;
                }
            } else if (!((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue()) {
                this.canShowPatreonMessage = false;
            }
        }
    }

    private void sendPatreonMessage(class_3222 serverPlayer) {
        class_5250 component = class_2561.method_43471((String)"gui.aether.patreon.message");
        List<String> unlinkedBodyArray = Arrays.stream(component.getString().split("(?=(%s1))|(?<=(%s1))|(?=(%s2))|(?<=(%s2))|(?=(%s3))|(?<=(%s3))")).toList();
        List<class_5250> bodyArray = unlinkedBodyArray.stream().map(string -> switch (string) {
            case "%s1" -> class_2561.method_43470((String)"The Aether").method_10862(class_2583.field_24360.method_36139(8445183).method_10978(Boolean.valueOf(true)));
            case "%s2" -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"! ").method_10862(DISCORD.method_27704(LOGOMARKS))).method_10852((class_2561)class_2561.method_43470((String)"Discord").method_10862(DISCORD));
            case "%s3" -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)", ").method_10862(PATREON.method_27704(LOGOMARKS))).method_10852((class_2561)class_2561.method_43470((String)"Patreon").method_10862(PATREON));
            default -> class_2561.method_43470((String)string);
        }).toList();
        class_5250 message = class_2561.method_43470((String)"");
        bodyArray.forEach(arg_0 -> ((class_5250)message).method_10852(arg_0));
        serverPlayer.method_43496((class_2561)message);
        class_5250 note = class_2561.method_43471((String)"gui.aether.patreon.note").method_10862(class_2583.field_24360.method_36139(0x747474).method_10978(Boolean.valueOf(true)));
        serverPlayer.method_43496((class_2561)note);
    }

    @Override
    public void givePortalItem() {
        if (this.canGetPortal()) {
            this.getPlayer().method_7270(new class_1799((class_1935)AetherItems.AETHER_PORTAL_FRAME.get()));
            this.setCanGetPortal(false);
        }
    }

    @Override
    public void setCanGetPortal(boolean canGetPortal) {
        this.canGetPortal = canGetPortal;
    }

    @Override
    public boolean canGetPortal() {
        return this.canGetPortal;
    }

    @Override
    public void setInPortal(boolean inPortal) {
        this.isInAetherPortal = inPortal;
    }

    @Override
    public boolean isInPortal() {
        return this.isInAetherPortal;
    }

    @Override
    public void setPortalTimer(int timer) {
        this.aetherPortalTimer = timer;
    }

    @Override
    public int getPortalTimer() {
        return this.aetherPortalTimer;
    }

    @Override
    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    @Override
    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    @Override
    public void setHitting(boolean isHitting) {
        this.isHitting = isHitting;
    }

    @Override
    public boolean isHitting() {
        return this.isHitting;
    }

    @Override
    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setGravititeJumpActive(boolean isGravititeJumpActive) {
        this.isGravititeJumpActive = isGravititeJumpActive;
    }

    @Override
    public boolean isGravititeJumpActive() {
        return this.isGravititeJumpActive;
    }

    @Override
    public void setSeenSunSpiritDialogue(boolean seenDialogue) {
        this.seenSunSpiritDialogue = seenDialogue;
    }

    @Override
    public boolean hasSeenSunSpiritDialogue() {
        return this.seenSunSpiritDialogue;
    }

    @Override
    public void setGoldenDartCount(int count) {
        this.goldenDartCount = count;
    }

    @Override
    public int getGoldenDartCount() {
        return this.goldenDartCount;
    }

    @Override
    public void setPoisonDartCount(int count) {
        this.poisonDartCount = count;
    }

    @Override
    public int getPoisonDartCount() {
        return this.poisonDartCount;
    }

    @Override
    public void setEnchantedDartCount(int count) {
        this.enchantedDartCount = count;
    }

    @Override
    public int getEnchantedDartCount() {
        return this.enchantedDartCount;
    }

    @Override
    public void setRemedyStartDuration(int duration) {
        this.remedyStartDuration = duration;
    }

    @Override
    public int getRemedyStartDuration() {
        return this.remedyStartDuration;
    }

    @Override
    public void setProjectileImpactedMaximum(int projectileImpactedMaximum) {
        this.impactedMaximum = projectileImpactedMaximum;
    }

    @Override
    public int getProjectileImpactedMaximum() {
        return this.impactedMaximum;
    }

    @Override
    public void setProjectileImpactedTimer(int projectileImpactedTimer) {
        this.impactedTimer = projectileImpactedTimer;
    }

    @Override
    public int getProjectileImpactedTimer() {
        return this.impactedTimer;
    }

    @Override
    public void setVampireHealing(boolean performVampireHealing) {
        this.performVampireHealing = performVampireHealing;
    }

    @Override
    public boolean performVampireHealing() {
        return this.performVampireHealing;
    }

    @Override
    @Nullable
    public void setMountedAerbunny(Aerbunny mountedAerbunny) {
        this.mountedAerbunny = mountedAerbunny;
    }

    @Override
    @Nullable
    public Aerbunny getMountedAerbunny() {
        return this.mountedAerbunny;
    }

    @Override
    @Nullable
    public void setMountedAerbunnyTag(class_2487 mountedAerbunnyTag) {
        this.mountedAerbunnyTag = mountedAerbunnyTag;
    }

    @Override
    @Nullable
    public class_2487 getMountedAerbunnyTag() {
        return this.mountedAerbunnyTag;
    }

    @Override
    public void setLastRiddenMoa(@Nullable UUID lastRiddenMoa) {
        this.lastRiddenMoa = lastRiddenMoa;
    }

    @Override
    @Nullable
    public UUID getLastRiddenMoa() {
        return this.lastRiddenMoa;
    }

    @Override
    public void setCloudMinions(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        this.sendCloudMinionPacket(cloudMinionRight, cloudMinionLeft);
        this.cloudMinions.add(0, cloudMinionRight);
        this.cloudMinions.add(1, cloudMinionLeft);
    }

    @Override
    public List<CloudMinion> getCloudMinions() {
        return this.cloudMinions;
    }

    @Override
    public int getWingRotationO() {
        return this.wingRotationO;
    }

    @Override
    public int getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setAttackedWithInvisibility(boolean attacked) {
        this.attackedWithInvisibility = attacked;
    }

    @Override
    public boolean attackedWithInvisibility() {
        return this.attackedWithInvisibility;
    }

    @Override
    public void setInvisibilityEnabled(boolean enabled) {
        this.invisibilityEnabled = enabled;
    }

    @Override
    public boolean isInvisibilityEnabled() {
        return this.invisibilityEnabled;
    }

    @Override
    public void setWearingInvisibilityCloak(boolean wearing) {
        this.wearingInvisibilityCloak = wearing;
    }

    @Override
    public boolean isWearingInvisibilityCloak() {
        return this.wearingInvisibilityCloak;
    }

    @Override
    public int getFlightTimerMax() {
        return 52;
    }

    @Override
    public float getFlightModifierMax() {
        return 15.0f;
    }

    @Override
    public void setFlightTimer(int timer) {
        this.flightTimer = timer;
    }

    @Override
    public int getFlightTimer() {
        return this.flightTimer;
    }

    @Override
    public void setFlightModifier(float modifier) {
        this.flightModifier = modifier;
    }

    @Override
    public float getFlightModifier() {
        return this.flightModifier;
    }

    @Override
    public void setSavedHealth(float health) {
        this.savedHealth = health;
    }

    @Override
    public float getSavedHealth() {
        return this.savedHealth;
    }

    @Override
    public void setNeptuneSubmergeLength(double length) {
        this.neptuneSubmergeLength = length;
    }

    @Override
    public double getNeptuneSubmergeLength() {
        return this.neptuneSubmergeLength;
    }

    @Override
    public void setPhoenixSubmergeLength(double length) {
        this.phoenixSubmergeLength = length;
    }

    @Override
    public double getPhoenixSubmergeLength() {
        return this.phoenixSubmergeLength;
    }

    @Override
    public int getObsidianConversionTimerMax() {
        return 20;
    }

    @Override
    public void setObsidianConversionTime(int time) {
        this.obsidianConversionTime = time;
    }

    @Override
    public int getObsidianConversionTime() {
        return this.obsidianConversionTime;
    }

    @Override
    public void setLifeShardCount(int amount) {
        this.lifeShards = amount;
    }

    @Override
    public int getLifeShardCount() {
        return this.lifeShards;
    }

    @Override
    public int getLifeShardLimit() {
        return (Integer)AetherConfig.SERVER.maximum_life_shards.get();
    }

    @Override
    public class_1322 getLifeShardHealthAttributeModifier() {
        return new class_1322(LIFE_SHARD_HEALTH_ID, "Life Shard health increase", (double)((float)this.getLifeShardCount() * 2.0f), class_1322.class_1323.field_6328);
    }

    private void sendCloudMinionPacket(CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        class_1657 class_16572 = this.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (!this.getPlayer().method_37908().field_9236) {
                PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new CloudMinionPacket(this.getPlayer().method_5628(), cloudMinionRight.method_5628(), cloudMinionLeft.method_5628()), (class_3222)serverPlayer);
            }
        }
    }

    private boolean shouldSyncBetweenClients() {
        return this.shouldSyncBetweenClients;
    }

    private void setShouldSyncBetweenClients(boolean shouldSyncBetweenClients) {
        this.shouldSyncBetweenClients = shouldSyncBetweenClients;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new AetherPlayerSyncPacket(this.getPlayer().method_5628(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

